<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Plugin\GiftCardAccount\Model;

use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardPremiumFunctionality\Model\GiftCardAccount\Command\Redeem\AmStoreCredit\Checker;

class GiftCardAccountFormatterPlugin
{
    /**
     * @var Checker
     */
    private $checker;

    /**
     * @param Checker $checker
     */
    public function __construct(Checker $checker)
    {
        $this->checker = $checker;
    }

    /**
     * @param $subject
     * @param $result
     * @param GiftCardAccountInterface $account
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetFormattedData($subject, $result, GiftCardAccountInterface $account): array
    {
        $result['isRedeemable'] = $this->checker->canAccountBeRedeemed($account);

        return $result;
    }
}
