<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Plugin\GiftCardAccount\Model\GiftCardAccount\GiftCardAccountsGenerator;

use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardAccount\Model\GiftCardAccount\GiftCardAccountsGenerator;
use Magento\Framework\DataObject;

class UpdateAccountData
{
    public function beforeGenerate(GiftCardAccountsGenerator $subject, DataObject $accountsFormData): void
    {
        $data = $accountsFormData->getData();

        if (isset($data['use_default'])) {
            if (!empty($data['use_default'][GiftCardAccountInterface::IS_REDEEMABLE])) {
                $data[GiftCardAccountInterface::IS_REDEEMABLE] = null;
            }
            unset($data['use_default']);
        }

        if (isset($data['isRedeemableUseDefault'])) {
            unset($data['isRedeemableUseDefault']);
        }

        $accountsFormData->setData($data);
    }
}
