<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Model\Layout\Customer\Codes;

use Amasty\GiftCardAccount\Model\Layout\Customer\LayoutProcessorInterface;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Framework\UrlInterface;

class RedeemButton implements LayoutProcessorInterface
{
    /**
     * @var ArrayManager
     */
    private $arrayManager;

    /**
     * @var UrlInterface
     */
    private $url;

    public function __construct(
        ArrayManager $arrayManager,
        UrlInterface $url
    ) {
        $this->arrayManager = $arrayManager;
        $this->url = $url;
    }

    public function process(array $jsLayout): array
    {
        $redeemUrl = $this->url->getUrl('amgcardpremium/account/redeem');
        $codesButtonConfig = [
            'redeem-button' => [
                'component' => 'Amasty_GiftCardPremiumFunctionality/js/view/account/codes/redeem-button',
                'redeemCardUrl' => $redeemUrl,
                'sortOrder' => 5
            ]
        ];
        $component = 'components/amcard-account-render/children/action-button/children';
        $jsLayout = $this->arrayManager->merge(
            $component,
            $jsLayout,
            $codesButtonConfig
        );

        return $jsLayout;
    }
}
