<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Model\Layout\Customer\Cards;

use Amasty\GiftCardAccount\Model\Layout\Customer\LayoutProcessorInterface;
use Amasty\GiftCardPremiumFunctionality\Model\GiftCardAccount\Command\Redeem\AmStoreCredit\Checker;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Framework\UrlInterface;

class RedeemButton implements LayoutProcessorInterface
{
    /**
     * @var ArrayManager
     */
    private $arrayManager;

    /**
     * @var Checker
     */
    private $checker;

    /**
     * @var UrlInterface
     */
    private $url;

    public function __construct(
        ArrayManager $arrayManager,
        Checker $checker,
        UrlInterface $url
    ) {
        $this->arrayManager = $arrayManager;
        $this->checker = $checker;
        $this->url = $url;
    }

    public function process(array $jsLayout): array
    {
        if ($this->checker->canBeRedeemed()) {
            $redeemUrl = $this->url->getUrl('amgcardpremium/account/redeem');
            $cardsButtonConfig = [
                'redeem-button' => [
                    'component' => 'Amasty_GiftCardPremiumFunctionality/js/view/account/cards/redeem-button',
                    'redeemCardUrl' => $redeemUrl
                ]
            ];
            $component = 'components/amcard-giftcards/children/after-action-button/children';
            $jsLayout = $this->arrayManager->merge(
                $component,
                $jsLayout,
                $cardsButtonConfig
            );
        }

        return $jsLayout;
    }
}
