<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Model\GiftCardAccount\DataProvider\Form\Modifier;

use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardPremiumFunctionality\Model\ConfigProvider;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class IsRedeemable implements ModifierInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @param ConfigProvider $configProvider
     */
    public function __construct(ConfigProvider $configProvider)
    {
        $this->configProvider = $configProvider;
    }

    public function modifyData(array $data)
    {
        if (!isset($data[GiftCardAccountInterface::IS_REDEEMABLE])
            || $data[GiftCardAccountInterface::IS_REDEEMABLE]=== null
        ) {
            $data['isRedeemableUseDefault'] = true;
            $data['is_redeemable'] = (string)(int)$this->configProvider->isRedemptionForAmStoreCredit();
        } else {
            $data['isRedeemableUseDefault'] = false;
        }

        return $data;
    }

    public function modifyMeta(array $meta)
    {
        return $meta;
    }
}
