<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Model\GiftCardAccount\Command\Redeem\AmStoreCredit\Validator;

use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardPremiumFunctionality\Model\GiftCardAccount\Command\Redeem\AmStoreCredit\Checker;
use Magento\Framework\Validator\AbstractValidator;

class Common extends AbstractValidator
{
    /**
     * @var Checker
     */
    private $checker;

    /**
     * @param Checker $checker
     */
    public function __construct(Checker $checker)
    {
        $this->checker = $checker;
    }

    /**
     * @param GiftCardAccountInterface $value
     * @return bool
     */
    public function isValid($value): bool
    {
        $gcCode = $value->getCodeModel()->getCode();

        $errors = [];
        if (!$this->checker->canAccountBeRedeemed($value)) {
            $errors[] = __('The specified Gift Card Account is not redeemable.');
        }
        if (!$this->checker->canBeRedeemed()) {
            $errors[] = __('Gift Card "%1" cannot be redeemed for store credit.', $gcCode);
        }
        $this->_addMessages($errors);

        return empty($this->getMessages());
    }
}
