<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Model\GiftCardAccount\Command\Redeem\AmStoreCredit;

use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardAccount\Model\GiftCardAccount\Command\Redeem\ProcessorInterface;
use Amasty\StoreCredit\Model\History\MessageProcessor;
use Amasty\StoreCredit\Model\StoreCredit\ManageCustomerStoreCredit;
use Magento\Framework\ObjectManagerInterface;

class Processor implements ProcessorInterface
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(ObjectManagerInterface $objectManager)
    {
        $this->objectManager = $objectManager;
    }

    /**
     * @param GiftCardAccountInterface $account
     * @param int $customerId
     * @param float $amount
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     * @throws \Magento\Framework\Exception\LocalizedException
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function execute(GiftCardAccountInterface $account, int $customerId, float $amount)
    {
        $this->getStoreCreditCustomerManager()->addOrSubtractStoreCredit(
            $customerId,
            $amount,
            MessageProcessor::ADMIN_BALANCE_CHANGE_PLUS,
            [],
            null,
            'Redeem from Gift Card Account',
            true
        );
    }

    /**
     * @return ManageCustomerStoreCredit
     */
    private function getStoreCreditCustomerManager()
    {
        return $this->objectManager->get(ManageCustomerStoreCredit::class);
    }
}
