<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Model\GiftCardAccount\Command\Redeem\AmStoreCredit;

use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardAccount\Model\OptionSource\AccountStatus;
use Amasty\GiftCardPremiumFunctionality\Model\ConfigProvider;

class Checker
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(ConfigProvider $configProvider)
    {
        $this->configProvider = $configProvider;
    }

    public function canAccountBeRedeemed(GiftCardAccountInterface $account): bool
    {
        return $account->getStatus() == AccountStatus::STATUS_ACTIVE
            && (($this->canBeRedeemed() && $account->isRedeemable() === null)
                || ($this->canBeRedeemed() && $account->isRedeemable()));
    }

    public function canBeRedeemed(): bool
    {
        return $this->configProvider->isAmStoreCreditEnabled()
            && $this->configProvider->isRedemptionForAmStoreCredit();
    }
}
