<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Premium Functionality for Magento 2 (System)
 */

namespace Amasty\GiftCardPremiumFunctionality\Model;

use Amasty\GiftCard\Model\ConfigProvider as GiftCardConfigProvider;
use Amasty\StoreCredit\Model\ConfigProvider as StoreCreditConfigProvider;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Module\Manager as ModuleManager;
use Magento\Framework\ObjectManagerInterface;

class ConfigProvider extends GiftCardConfigProvider
{
    /**#@+
     * Constants defined for xpath of system configuration
     */
    public const XPATH_ALLOW_REDEMPTION_FOR_AM_STORE_CREDIT = 'general/allow_redemption_for_am_store_credit';
    /**#@-*/

    /**
     * @var ModuleManager
     */
    private $moduleManager;

    /**
     * @var StoreCreditConfigProvider
     */
    private $storeCreditConfigProvider;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        ModuleManager $moduleManager,
        StoreCreditConfigProvider $storeCreditConfigProvider
    ) {
        parent::__construct($scopeConfig);
        $this->moduleManager = $moduleManager;
        $this->storeCreditConfigProvider = $storeCreditConfigProvider;
    }

    /**
     * @param int|null $storeId
     * @return bool
     */
    public function isRedemptionForAmStoreCredit($storeId = null): bool
    {
        return (bool)$this->getValue(self::XPATH_ALLOW_REDEMPTION_FOR_AM_STORE_CREDIT, $storeId);
    }

    /**
     * @return bool
     */
    public function isAmStoreCreditEnabled(): bool
    {
        return $this->moduleManager->isEnabled('Amasty_StoreCredit')
            && $this->storeCreditConfigProvider->isEnabled();
    }
}
