<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

use Amasty\GiftCard\Api\CodePoolRepositoryInterface;
use Amasty\GiftCard\Api\CodeRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var CodePoolRepositoryInterface $codePoolRepository */
$codePoolRepository = $objectManager->get(CodePoolRepositoryInterface::class);

/** @var CodeRepositoryInterface $codeRepository */
$codeRepository = $objectManager->get(CodeRepositoryInterface::class);

$codes = $codeRepository->getCodesByTemplate('AM_TEST_%');

$codePools = $codePoolRepository->getList();

foreach ($codePools as $codePool) {
    if ($codePool->getTitle() == 'Amasty Test Code Pool') {
        $codePoolRepository->delete($codePool);
    }
}

foreach ($codes as $code) {
    $codeRepository->delete($codeRepository->getByCode($code));
}
