<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

use Amasty\GiftCard\Api\CodeGeneratorManagementInterface;
use Amasty\GiftCard\Api\CodePoolRepositoryInterface;
use Amasty\GiftCard\Api\Data\CodePoolInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var CodePoolRepositoryInterface $codePoolRepository */
$codePoolRepository = $objectManager->get(CodePoolRepositoryInterface::class);

/** @var CodePoolInterface $codePool */
$codePool = $objectManager->get(CodePoolInterface::class);

/** @var CodeGeneratorManagementInterface $codeGeneratorManagement */
$codeGeneratorManagement = $objectManager->get(CodeGeneratorManagementInterface::class);

$codePool->setTitle('Amasty Test Code Pool');
$codePool->setTemplate('AM_TEST_{D}');

$codePoolRepository->save($codePool);

$codeGeneratorManagement->generateCodesForCodePool($codePool->getCodePoolId(), 8);
