<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

use Amasty\GiftCard\Api\CodePoolRepositoryInterface;
use Amasty\GiftCard\Api\CodeRepositoryInterface;
use Amasty\GiftCardAccount\Api\GiftCardAccountRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

$objectManager = Bootstrap::getObjectManager();

/** @var GiftCardAccountRepositoryInterface $codeAccountRepository */
$codeAccountRepository = $objectManager->get(GiftCardAccountRepositoryInterface::class);

/** @var CodeRepositoryInterface $codeRepository */
$codeRepository = $objectManager->get(CodeRepositoryInterface::class);

/** @var CodePoolRepositoryInterface $codeRepository */
$codePoolRepository = $objectManager->get(CodePoolRepositoryInterface::class);


$codeAccounts = $codeAccountRepository->getList();

foreach ($codeAccounts as $codeAccount) {
    if (strpos($codeAccount->getCodeModel()->getCode(), 'AM_TEST') !== false) {
        $codeAccountRepository->delete($codeAccount);
    }
}


Resolver::getInstance()->requireDataFixture(
    'Amasty_GiftCardGraphQl::Test/GraphQl/_files/am_gift_card_generate_codes_rollback.php'
);
Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/customer_with_addresses_rollback.php');
