<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

use Amasty\GiftCard\Api\CodePoolRepositoryInterface;
use Amasty\GiftCard\Api\CodeRepositoryInterface;
use Amasty\GiftCardAccount\Api\CustomerCardRepositoryInterface;
use Amasty\GiftCardAccount\Api\Data\CustomerCardInterface;
use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardAccount\Api\GiftCardAccountRepositoryInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture(
    'Amasty_GiftCardGraphQl::Test/GraphQl/_files/am_gift_card_generate_codes.php'
);
Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/customer_with_addresses.php');

$objectManager = Bootstrap::getObjectManager();

/** @var GiftCardAccountRepositoryInterface $codeAccountRepository */
$codeAccountRepository = $objectManager->get(GiftCardAccountRepositoryInterface::class);

/** @var CodeRepositoryInterface $codeRepository */
$codeRepository = $objectManager->get(CodeRepositoryInterface::class);

/** @var CodePoolRepositoryInterface $codeRepository */
$codePoolRepository = $objectManager->get(CodePoolRepositoryInterface::class);

/** @var CustomerRepositoryInterface $customerRepository */
$customerRepository = $objectManager->get(CustomerRepositoryInterface::class);

/** @var CustomerCardInterface $customerCard */

/** @var CustomerCardRepositoryInterface $customerCardRepository */
$customerCardRepository = $objectManager->get(CustomerCardRepositoryInterface::class);

$customer = $customerRepository->get('customer_with_addresses@test.com');

$poolId = 0;
$pools = $codePoolRepository->getList();
foreach ($pools as $pool) {
    if ($pool->getTitle() == 'Amasty Test Code Pool') {
        $poolId = $pool->getCodePoolId();
    }
}

$codes = $codeRepository->getAvailableCodesByCodePoolId($poolId);

foreach ($codes as $code) {
    $code->setStatus(1);
    $codeRepository->save($code);

    /** @var GiftCardAccountInterface $codeAccount */
    $codeAccount = $objectManager->create(GiftCardAccountInterface::class);
    $codeAccount->setCodeId((int)$code->getId());
    $codeAccount->setImageId(1);
    $codeAccount->setWebsiteId(1);
    $codeAccount->setStatus(1);
    $codeAccount->setUsage('multiple');
    $codeAccount->setIsSent(false);

    if ($code->getCode() == 'AM_TEST_3') {
        $codeAccount->setInitialValue(1200);
        $codeAccount->setCurrentValue(800);
        $codeAccountRepository->save($codeAccount);

        continue;
    }

    if ($code->getCode() == 'AM_TEST_4') {
        $codeAccount->setInitialValue(1000);
        $codeAccount->setCurrentValue(900);
        $codeAccount->setCustomerCreatedId((int)$customer->getId());
        $codeAccountRepository->save($codeAccount);

        $customerCard = $objectManager->create(CustomerCardInterface::class);
        $customerCard->setCustomerId((int)$customer->getId());
        $customerCard->setAccountId($codeAccount->getAccountId());
        $customerCardRepository->save($customerCard);

        continue;
    }

    if ($code->getCode() == 'AM_TEST_8') {
        $codeAccount->setInitialValue(3000);
        $codeAccount->setCurrentValue(1200);
        $codeAccount->setCustomerCreatedId((int)$customer->getId());
        $codeAccount->setStatus(0);
        $codeAccountRepository->save($codeAccount);

        $customerCard = $objectManager->create(CustomerCardInterface::class);
        $customerCard->setCustomerId((int)$customer->getId());
        $customerCard->setAccountId($codeAccount->getAccountId());
        $customerCardRepository->save($customerCard);

        continue;
    }

    $codeAccount->setInitialValue(2000);
    $codeAccount->setCurrentValue(2000);

    $codeAccountRepository->save($codeAccount);
}
