<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

namespace Amasty\GiftCardGraphQl\Test\GraphQl;

use Magento\TestFramework\TestCase\GraphQlAbstract;

class GetAmGiftCardSettingTest extends GraphQlAbstract
{
    private const MAIN_RESPONSE_KEY = 'amGiftCardSetting';

    /**
     * @group amasty_gift_card
     *
     * @magentoConfigFixture base_website amgiftcard/general/active 1
     * @magentoConfigFixture base_website amgiftcard/general/allowed_product_types simple
     * @magentoConfigFixture base_website amgiftcard/general/allow_to_paid_for_shipping 1
     * @magentoConfigFixture base_website amgiftcard/general/allow_to_paid_for_tax 1
     * @magentoConfigFixture base_website amgiftcard/general/allow_to_paid_for_amasty_extra_fee 0
     * @magentoConfigFixture base_website amgiftcard/display_options/fields am_giftcard_date_delivery
     * @magentoConfigFixture base_website amgiftcard/display_options/show_options_in_cart_checkout 1
     * @magentoConfigFixture base_website amgiftcard/display_options/gift_card_timezone Europe/Paris
     * @magentoConfigFixture base_website amgiftcard/display_options/allow_user_images 1
     * @magentoConfigFixture base_website amgiftcard/display_options/image_upload_tooltip Test
     * @magentoConfigFixture base_website amgiftcard/card/lifetime 5
     * @magentoConfigFixture base_website amgiftcard/card/allow_use_themselves false
     */
    public function testGetAmGiftCardSetting(): void
    {
        $assertArray = [
            'allowedProductTypes' => [
                'simple'
            ],
            'giftCardFields' => ['am_giftcard_date_delivery'],
            'giftCardLifetime' => 5,
            'imageUploadTooltip' => 'Test',
            'isAllowUseThemselves' => true,
            'isAllowUserImages' => true,
            'isEnabled' => true,
            'isExtraFeePaidAllowed' => false,
            'isShowOnCartAndCheckout' => true,
            'isSippingPaidAllowed' => true,
            'isTaxPaidAllowed' => true
        ];

        $response = $this->graphQlQuery($this->getQuery());

        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $response);

        $this->assertResponseFields($response[self::MAIN_RESPONSE_KEY], $assertArray);
    }

    private function getQuery(): string
    {
        return <<<QUERY
query {
    amGiftCardSetting {
        allowedProductTypes
        giftCardFields
        giftCardLifetime
        imageUploadTooltip
        isAllowUseThemselves
        isAllowUserImages
        isEnabled
        isExtraFeePaidAllowed
        isShowOnCartAndCheckout
        isSippingPaidAllowed
        isTaxPaidAllowed
    }
}
QUERY;
    }
}
