<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

namespace Amasty\GiftCardGraphQl\Test\GraphQl;

use Magento\TestFramework\TestCase\GraphQlAbstract;

class GetAmGiftCardPreviewTest extends GraphQlAbstract
{
    private const MAIN_KEY = 'amGiftCardPreview';
    private const CONT_KEY = 'content';

    /**
     * @group amasty_gift_card
     *
     * @magentoConfigFixture base_website amgiftcard/general/active 1
     */
    public function testGetAmGiftCardPreview(): void
    {
        $variables = [
            'amGiftcardAmount' => 15,
            'amGiftcardImage' => 3,
            'amGiftcardMessage' => 'Gift Test Message',
            'amGiftcardRecipientName' => 'test_recepient@email.com',
            'amGiftcardSenderName' => 'test_sender@email.com'
        ];

        $response = $this->graphQlQuery($this->getQuery(), $variables);

        $this->assertArrayHasKey(self::MAIN_KEY, $response);
        $this->assertArrayHasKey(self::CONT_KEY, $response[self::MAIN_KEY]);

        $this->assertStringContainsString(
            (string)$variables['amGiftcardAmount'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardImage'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardMessage'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardRecipientName'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardSenderName'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
    }

    /**
     * @group amasty_gift_card
     *
     * @magentoConfigFixture base_website amgiftcard/general/active 1
     */
    public function testGetAmGiftCardPreviewCustom(): void
    {
        $variables = [
            'amGiftcardAmountCustom' => 33,
            'amGiftcardCustomImage' => 'test_image',
            'amGiftcardMessage' => 'Gift Test Message',
            'amGiftcardRecipientName' => 'test_recepient@email.com',
            'amGiftcardSenderName' => 'test_sender@email.com'
        ];

        $response = $this->graphQlQuery($this->getQueryCustom(), $variables);

        $this->assertArrayHasKey(self::MAIN_KEY, $response);
        $this->assertArrayHasKey(self::CONT_KEY, $response[self::MAIN_KEY]);

        $this->assertStringContainsString(
            (string)$variables['amGiftcardAmountCustom'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardCustomImage'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardMessage'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardRecipientName'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
        $this->assertStringContainsString(
            (string)$variables['amGiftcardSenderName'],
            $response[self::MAIN_KEY][self::CONT_KEY]
        );
    }

    private function getQuery(): string
    {
        return <<<'QUERY'
query AmGiftCardPreview (
    $amGiftcardAmount: Float,
    $amGiftcardImage: Int,
    $amGiftcardMessage: String,
    $amGiftcardRecipientName: String,
    $amGiftcardSenderName: String
    ) {
    amGiftCardPreview (
        input: {
            am_giftcard_amount:$amGiftcardAmount,
            am_giftcard_image:$amGiftcardImage,
            am_giftcard_message:$amGiftcardMessage,
            am_giftcard_recipient_name:$amGiftcardRecipientName,
            am_giftcard_sender_name:$amGiftcardSenderName
        }) {
            content
    }
}
QUERY;
    }

    private function getQueryCustom(): string
    {
        return <<<'QUERY'
query AmGiftCardPreview (
    $amGiftcardAmountCustom: Float,
    $amGiftcardCustomImage: String,
    $amGiftcardMessage: String,
    $amGiftcardRecipientName: String,
    $amGiftcardSenderName: String
    ) {
    amGiftCardPreview (
        input: {
            am_giftcard_amount_custom:$amGiftcardAmountCustom,
            am_giftcard_custom_image:$amGiftcardCustomImage,
            am_giftcard_message:$amGiftcardMessage,
            am_giftcard_recipient_name:$amGiftcardRecipientName,
            am_giftcard_sender_name:$amGiftcardSenderName
        }) {
            content
    }
}
QUERY;
    }
}
