<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

namespace Amasty\GiftCardGraphQl\Test\GraphQl;

use Magento\TestFramework\TestCase\GraphQlAbstract;

class GetAmGiftCardAccountTest extends GraphQlAbstract
{
    private const MAIN_RESPONSE_KEY = 'amGiftCardAccount';

    /**
     * @group amasty_gift_card
     *
     * @magentoConfigFixture base_website amgiftcard/general/active 1
     *
     * @magentoApiDataFixture Amasty_GiftCardGraphQl::Test/GraphQl/_files/am_gift_card_code_accounts.php
     */
    public function testGetAmGiftCardAccount(): void
    {
        $cardAccountCode = 'AM_TEST_3';

        $assertArray = [
            "code" => $cardAccountCode,
            "current_balance" => [
                "currency" => "USD",
                "value" => 800
            ],
            "expiration_date" => "Unlimited",
            "status" => "Active"
        ];

        $response = $this->graphQlQuery($this->getQuery($cardAccountCode));

        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $response);

        $this->assertResponseFields($response[self::MAIN_RESPONSE_KEY], $assertArray);
    }

    private function getQuery(string $code): string
    {
        return <<<QUERY
query {
    amGiftCardAccount(
      input: {
        am_gift_card_code:"$code"
      }
    ) {
        code
        current_balance {
          currency
          value
        }
        expiration_date
        status
    }
}
QUERY;
    }
}
