<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

namespace Amasty\GiftCardGraphQl\Test\GraphQl;

use Magento\GraphQl\Quote\GetMaskedQuoteIdByReservedOrderId;
use Magento\Integration\Api\CustomerTokenServiceInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class ApplyAmGiftCardToCartTest extends GraphQlAbstract
{
    private const MAIN_RESPONSE_KEY = 'applyAmGiftCardToCart';

    /**
     * @var GetMaskedQuoteIdByReservedOrderId
     */
    private $getMaskedQuoteIdByReservedOrderId;

    protected function setUp(): void
    {
        parent::setUp();

        $objectManager = Bootstrap::getObjectManager();
        $this->getMaskedQuoteIdByReservedOrderId = $objectManager->get(GetMaskedQuoteIdByReservedOrderId::class);
    }

    /**
     * @group amasty_gift_card
     *
     * @magentoConfigFixture base_website amgiftcard/general/active 1
     *
     * @magentoApiDataFixture Amasty_GiftCardGraphQl::Test/GraphQl/_files/am_customer_cart_with_product.php
     */
    public function testApplyAmGiftCardToCart(): void
    {
        $cardAccountCode = 'AM_TEST_4';

        $maskedQuote = $this->getMaskedQuoteIdByReservedOrderId->execute('am_gift_customer_quote');

        $variables = [
            'amGiftCardCode' => $cardAccountCode,
            'cartId' => $maskedQuote
        ];

        $assertArray = [
            'cart' => [
                'applied_am_gift_cards' => [
                    [
                        'applied_balance' => [
                            'currency' => 'USD',
                            'value' => 40
                        ],
                        'code' => $cardAccountCode,
                        'current_balance' => [
                            'currency' => 'USD',
                            'value' => 900
                        ],
                        'expiration_date' => null
                    ]
                ],
                'prices' => [
                    'grand_total' => [
                        'value' => 0
                    ]
                ]
            ]
        ];

        $response = $this->graphQlMutation($this->getQuery(), $variables);

        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_RESPONSE_KEY], $assertArray);
    }

    private function getQuery(): string
    {
        return <<<'QUERY'
mutation ApplyAmGiftCardToCart (
    $amGiftCardCode: String!,
    $cartId: String!
    ){
    applyAmGiftCardToCart (
      input: {
        am_gift_card_code:$amGiftCardCode,
        cart_id:$cartId
      }
    ) {
        cart {
            applied_am_gift_cards {
                applied_balance {
                    currency
                    value
                }
                code
                current_balance {
                    currency
                    value
                }
                expiration_date
            }
            prices {
                grand_total {
                    value
                }
            }
        }
    }
}
QUERY;
    }
}
