<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

namespace Amasty\GiftCardGraphQl\Test\GraphQl;

use Magento\Framework\Exception\AuthenticationException;
use Magento\Integration\Api\CustomerTokenServiceInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AddAmGiftCardCodeToAccountTest extends GraphQlAbstract
{
    private const MAIN_RESPONSE_KEY = 'addAmGiftCardCodeToAccount';
    public const CUSTOMER = 'customer_with_addresses@test.com';
    public const CUSTOMER_PASS = 'password';

    /**
     * @var CustomerTokenServiceInterface
     */
    private $customerTokenService;

    protected function setUp(): void
    {
        parent::setUp();

        $this->customerTokenService = Bootstrap::getObjectManager()->get(CustomerTokenServiceInterface::class);
    }

    /**
     * @group amasty_gift_card
     *
     * @magentoConfigFixture base_website amgiftcard/general/active 1
     *
     * @magentoApiDataFixture Amasty_GiftCardGraphQl::Test/GraphQl/_files/am_gift_card_code_accounts.php
     */
    public function testAddAmGiftCardCodeToAccount(): void
    {
        $code = 'AM_TEST_6';

        $assertArray = [
            'error' => false,
            'message' => 'Gift Code added.'
        ];

        $response = $this->graphQlMutation($this->getQuery($code), [], '', $this->getHeader());

        $this->assertArrayHasKey(self::MAIN_RESPONSE_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_RESPONSE_KEY], $assertArray);
    }

    private function getQuery(string $code): string
    {
        return <<<QUERY
mutation {
    addAmGiftCardCodeToAccount (
      input: {
        am_giftcard_code:"$code",
      }
    ) {
        error
        message
    }
}
QUERY;
    }

    /**
     * @param string $userName
     * @param string $password
     *
     * @return string[]
     * @throws AuthenticationException
     */
    private function getHeader(
        string $userName = self::CUSTOMER,
        string $password = self::CUSTOMER_PASS
    ): array {
        $customerToken = $this->customerTokenService->createCustomerAccessToken($userName, $password);
        return ['Authorization' => 'Bearer ' . $customerToken];
    }
}
