<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card GraphQL for Magento 2 (System)
 */

namespace Amasty\GiftCardGraphQl\Api\Data;

interface ImageContentInterface
{
    public const BASE64_ENCODED_DATA = 'base64_encoded_data';
    public const EXTENSION = 'extension';
    public const FILENAME_WITH_EXTENSION = 'name_with_extension';

    /**
     * @return string
     */
    public function getBase64EncodedData(): string;

    /**
     * @param string $base64EncodedData
     *
     * @return ImageContentInterface
     */
    public function setBase64EncodedData(string $base64EncodedData): ImageContentInterface;

    /**
     * @return string
     */
    public function getFileNameWithExtension(): string;

    /**
     * @param string $filenameWithExtension
     *
     * @return ImageContentInterface
     */
    public function setFileNameWithExtension(string $filenameWithExtension): ImageContentInterface;

    /**
     * @param string $extension
     *
     * @return ImageContentInterface
     */
    public function setExtension(string $extension): ImageContentInterface;

    /**
     * @return string
     */
    public function getExtension(): string;
}
