<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Plugin\GiftCardAccount\Model\GiftCardAccount\GiftCardAccountsGenerator;

use Amasty\GiftCard\Model\CodePool\Repository as CodePoolRepository;
use Amasty\GiftCardAccount\Model\GiftCardAccount\GiftCardAccountsGenerator;
use Amasty\GiftCardCodesAutoGeneration\Model\Queue\Publisher;
use Magento\Framework\DataObject;
use Psr\Log\LoggerInterface;

class AddCodePoolsToQueue
{
    /**
     * @var CodePoolRepository
     */
    private $repository;

    /**
     * @var Publisher
     */
    private $publisher;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        CodePoolRepository $repository,
        Publisher $publisher,
        LoggerInterface $logger
    ) {
        $this->repository = $repository;
        $this->publisher = $publisher;
        $this->logger = $logger;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGenerate(
        GiftCardAccountsGenerator $subject,
        $result,
        DataObject $accountsFormData,
        int $qty
    ): void {
        if (!$accountsFormData->getCodePool()) {
            return;
        }

        try {
            $codePool = $this->repository->getById((int)$accountsFormData->getCodePool());
            $this->publisher->publish($codePool);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
    }
}
