<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Plugin\GiftCardAccount\Model\GiftCardAcccount\Repository;

use Amasty\GiftCard\Model\CodePool\Repository as CodePoolRepository;
use Amasty\GiftCardAccount\Api\Data\GiftCardAccountInterface;
use Amasty\GiftCardAccount\Model\GiftCardAccount\Repository;
use Amasty\GiftCardCodesAutoGeneration\Model\Queue\Publisher;
use Psr\Log\LoggerInterface;

class AddCodePoolToQueue
{
    /**
     * @var CodePoolRepository
     */
    private $repository;

    /**
     * @var Publisher
     */
    private $publisher;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        CodePoolRepository $repository,
        Publisher $publisher,
        LoggerInterface $logger
    ) {
        $this->repository = $repository;
        $this->publisher = $publisher;
        $this->logger = $logger;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterSave(
        Repository $subject,
        GiftCardAccountInterface $result,
        GiftCardAccountInterface $account
    ): GiftCardAccountInterface {
        if (!$account->getCodePool()) {
            return $result;
        }

        try {
            $codePool = $this->repository->getById((int)$account->getCodePool());
            $this->publisher->publish($codePool);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }

        return $result;
    }
}
