<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Plugin\GiftCard\Model\CodePool\DataProvider\Form;

use Amasty\GiftCard\Model\CodePool\DataProvider\Form;
use Amasty\GiftCard\Model\CodePool\Repository;
use Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\AutoGenerationData;

class AddAutoGenerationData
{
    /**
     * @var Repository
     */
    private $repository;

    public function __construct(
        Repository $repository
    ) {
        $this->repository = $repository;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetData(Form $subject, array $result): array
    {
        foreach ($result as $id => &$item) {
            try {
                $codePool = $this->repository->getById((int)$id);
                $autoGenerationData = $codePool->getExtensionAttributes()->getAutoGenerationData();
                if ($autoGenerationData && isset($item['codes'])) {
                    $item['codes']['auto_generation_data'][AutoGenerationData::IS_ENABLED]
                        = $autoGenerationData->isEnabled() ? '1' : '0';
                    $item['codes']['auto_generation_data'][AutoGenerationData::THRESHOLD_QTY]
                        = $autoGenerationData->getThresholdQty();
                }
            } catch (\Exception $e) {
                null; //skip loading
            }
        }

        return $result;
    }
}
