<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Observer;

use Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\Handlers\SaveHandler;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class SaveAutoGenerationData implements ObserverInterface
{
    /**
     * @var SaveHandler
     */
    private $saveHandler;

    public function __construct(
        SaveHandler $saveHandler
    ) {
        $this->saveHandler = $saveHandler;
    }

    public function execute(Observer $observer)
    {
        if ($codePool = $observer->getEvent()->getCodePool()) {
            $this->saveHandler->execute($codePool);
        }
    }
}
