<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Observer;

use Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\Handlers\LoadHandler;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class LoadAutoGenerationData implements ObserverInterface
{
    /**
     * @var LoadHandler
     */
    private $loadHandler;

    public function __construct(
        LoadHandler $loadHandler
    ) {
        $this->loadHandler = $loadHandler;
    }

    public function execute(Observer $observer)
    {
        if ($codePool = $observer->getEvent()->getCodePool()) {
            $this->loadHandler->execute($codePool);
        }
    }
}
