<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Model\ResourceModel\Queue;

use Amasty\GiftCardCodesAutoGeneration\Model\Queue\Publisher;
use Magento\MysqlMq\Model\QueueManagement;
use Magento\MysqlMq\Model\ResourceModel\Queue;

class GiftCardMessagesQueue extends Queue
{
    /**
     * To check in_progress status to prevent adding record to queue when generation is in progress
     */
    public function getGiftCardMessages(): array
    {
        $statuses = [
            QueueManagement::MESSAGE_STATUS_NEW,
            QueueManagement::MESSAGE_STATUS_IN_PROGRESS,
            QueueManagement::MESSAGE_STATUS_RETRY_REQUIRED
        ];

        $connection = $this->getConnection();
        $select = $connection->select()
            ->from(
                ['queue_message' => $this->getMessageTable()],
                [QueueManagement::MESSAGE_TOPIC => 'topic_name', QueueManagement::MESSAGE_BODY => 'body']
            )->join(
                ['queue_message_status' => $this->getMessageStatusTable()],
                'queue_message.id = queue_message_status.message_id',
                []
            )->join(
                ['queue' => $this->getQueueTable()],
                'queue.id = queue_message_status.queue_id',
                []
            )->where(
                'queue_message_status.status IN (?)',
                $statuses
            )->where('queue.name = ?', Publisher::TOPIC_NAME);

        return (array)$connection->fetchAll($select);
    }
}
