<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Model;

use Amasty\GiftCard\Model\ConfigProvider as GiftCardConfigProvider;

class ConfigProvider extends GiftCardConfigProvider
{
    public const NOTIFY_AUTO_GENERATION = 'email/notify_auto_generation';
    public const AUTO_GENERATION_EMAIL_TEMPLATE = 'email/auto_generation_email_template';
    public const AUTO_GENERATION_EMAIL_RECIPIENTS = 'email/auto_generation_email_recipients';
    public const AUTO_GENERATION_EMAIL_SENDER = 'email/auto_generation_email_sender';

    public function isNotifyAutoGeneration(?int $storeId = null): bool
    {
        return $this->isSetFlag(self::NOTIFY_AUTO_GENERATION, $storeId);
    }

    public function getAutoGenerationEmailTemplate(?int $storeId = null): string
    {
        return (string)$this->getValue(self::AUTO_GENERATION_EMAIL_TEMPLATE, $storeId);
    }

    public function getAutoGenerationEmailRecipients(?int $storeId = null): array
    {
        $recipientsArray = [];

        if ($recipients = $this->getValue(self::AUTO_GENERATION_EMAIL_RECIPIENTS, $storeId)) {
            $recipientsArray = array_filter(array_map('trim', preg_split('/\n|\r\n?/', $recipients)));
        }

        return $recipientsArray;
    }

    public function getAutoGenerationEmailSender(?int $storeId = null): string
    {
        return (string)$this->getValue(self::AUTO_GENERATION_EMAIL_SENDER, $storeId);
    }
}
