<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\Handlers;

use Amasty\GiftCard\Api\Data\CodePoolInterface;
use Amasty\GiftCardCodesAutoGeneration\Api\Data\AutoGenerationDataInterfaceFactory;
use Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\ResourceModel\AutoGenerationData;

class SaveHandler
{
    /**
     * @var AutoGenerationData
     */
    private $resource;

    /**
     * @var AutoGenerationDataInterfaceFactory
     */
    private $factory;

    public function __construct(
        AutoGenerationData $resource,
        AutoGenerationDataInterfaceFactory $factory
    ) {
        $this->resource = $resource;
        $this->factory = $factory;
    }

    public function execute(CodePoolInterface $codePool): void
    {
        if ($codePool->getData('auto_generation_data')) {
            $this->processNewData($codePool);
        }
        if ($data = $codePool->getExtensionAttributes()->getAutoGenerationData()) {
            $data->setCodePoolId($codePool->getCodePoolId());
            $this->resource->getConnection()->insertOnDuplicate(
                $this->resource->getMainTable(),
                $data->getData()
            );
        }
    }

    private function processNewData(CodePoolInterface $codePool): void
    {
        $autoGenerationData = $codePool->getData('auto_generation_data');
        $extensionAttributes = $codePool->getExtensionAttributes();
        if ($model = $extensionAttributes->getAutoGenerationData()) {
            $autoGenerationData = array_merge($model->getData(), $autoGenerationData);
        } else {
            $model = $this->factory->create();
        }
        $model->setData($autoGenerationData);
        $extensionAttributes->setAutoGenerationData($model);
        $codePool->setExtensionAttributes($extensionAttributes);
    }
}
