<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\Handlers;

use Amasty\GiftCard\Api\Data\CodePoolInterface;
use Amasty\GiftCardCodesAutoGeneration\Api\Data\AutoGenerationDataInterfaceFactory;
use Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\AutoGenerationData as AutoGenerationDataModel;
use Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData\ResourceModel\AutoGenerationData;

class LoadHandler
{
    /**
     * @var AutoGenerationData
     */
    private $resource;

    /**
     * @var AutoGenerationDataInterfaceFactory
     */
    private $factory;

    public function __construct(
        AutoGenerationData $resource,
        AutoGenerationDataInterfaceFactory $factory
    ) {
        $this->resource = $resource;
        $this->factory = $factory;
    }

    public function execute(CodePoolInterface $codePool): void
    {
        $extension = $codePool->getExtensionAttributes();
        if ($extension->getAutoGenerationData()) {
            return;
        }
        $data = $this->factory->create();
        $this->resource->load($data, $codePool->getCodePoolId(), AutoGenerationDataModel::CODE_POOL_ID);

        $extension->setAutoGenerationData($data);
        $codePool->setExtensionAttributes($extension);
    }
}
