<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Codes Auto-Generation
 */

namespace Amasty\GiftCardCodesAutoGeneration\Model\AutoGenerationData;

use Amasty\GiftCardCodesAutoGeneration\Api\Data\AutoGenerationDataInterface;
use Magento\Framework\Model\AbstractModel;

class AutoGenerationData extends AbstractModel implements AutoGenerationDataInterface
{
    public const RECORD_ID = 'record_id';
    public const CODE_POOL_ID = 'code_pool_id';
    public const IS_ENABLED = 'is_enabled';
    public const THRESHOLD_QTY = 'threshold_qty';

    protected function _construct()
    {
        $this->_init(ResourceModel\AutoGenerationData::class);
        $this->setIdFieldName(self::RECORD_ID);
    }

    public function setRecordId(int $id): void
    {
        $this->setData(self::RECORD_ID, $id);
    }

    public function getRecordId(): int
    {
        return (int)$this->_getData(self::RECORD_ID);
    }

    public function setCodePoolId(int $id): void
    {
        $this->setData(self::CODE_POOL_ID, $id);
    }

    public function getCodePoolId(): int
    {
        return (int)$this->_getData(self::CODE_POOL_ID);
    }

    public function setIsEnabled(bool $isEnabled): void
    {
        $this->setData(self::IS_ENABLED, $isEnabled);
    }

    public function isEnabled(): bool
    {
        return (bool)$this->_getData(self::IS_ENABLED);
    }

    public function setThresholdQty(int $threshold): void
    {
        $this->setData(self::THRESHOLD_QTY, $threshold);
    }

    public function getThresholdQty(): int
    {
        return (int)$this->_getData(self::THRESHOLD_QTY);
    }
}
