<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Account by Amasty (System)
 */

namespace Amasty\GiftCardAccount\Model\GiftCardExtension\Quote\ResourceModel;

use Amasty\GiftCardAccount\Api\Data\GiftCardQuoteInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class Quote extends AbstractDb
{
    public const TABLE_NAME = 'amasty_giftcard_quote';

    /**
     * @var array[]
     */
    protected $_serializableFields = [
        GiftCardQuoteInterface::GIFT_CARDS => ['[]', []]
    ];

    protected function _construct()
    {
        $this->_init(self::TABLE_NAME, GiftCardQuoteInterface::ENTITY_ID);
    }
}
