<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Account by Amasty (System)
 */

namespace Amasty\GiftCardAccount\Block\Adminhtml\Buttons\Account;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class CreateInBulkButton implements ButtonProviderInterface
{
    /**
     * @inheritdoc
     */
    public function getButtonData()
    {
        return [
            'label' => __('Generate in Bulk'),
            'class' => 'primary',
            'data_attribute' => [
                'mage-init' => [
                    'Magento_Ui/js/form/button-adapter' => [
                        'actions' => [
                            [
                                'targetName' => 'amgcard_account_listing.amgcard_account_listing.generate_in_bulk',
                                'actionName' => 'toggleModal'
                            ]
                        ]
                    ]
                ],
            ],
            'on_click' => '',
            'sort_order' => 5
        ];
    }
}
