<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card for Magento 2
 */

namespace Amasty\GiftCard\Api\Data;

interface CodePoolRuleInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const RULE_ID = 'rule_id';
    public const CODE_POOL_ID = 'code_pool_id';
    public const CONDITIONS_SERIALIZED = 'conditions_serialized';
    /**#@-*/

    /**
     * @param int $id
     *
     * @return \Amasty\GiftCard\Api\Data\CodePoolRuleInterface
     */
    public function setRuleId(int $id): \Amasty\GiftCard\Api\Data\CodePoolRuleInterface;

    /**
     * @return int
     */
    public function getRuleId(): int;

    /**
     * @param int $id
     *
     * @return \Amasty\GiftCard\Api\Data\CodePoolRuleInterface
     */
    public function setCodePoolId(int $id): \Amasty\GiftCard\Api\Data\CodePoolRuleInterface;

    /**
     * @return int
     */
    public function getCodePoolId(): int;

    /**
     * @param string $conditions
     *
     * @return \Amasty\GiftCard\Api\Data\CodePoolRuleInterface
     */
    public function setConditionsSerialized(string $conditions): \Amasty\GiftCard\Api\Data\CodePoolRuleInterface;

    /**
     * @return string|null
     */
    public function getConditionsSerialized();
}
