<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Hyva Compatibility (System)
 */

namespace Amasty\GdprHyva\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\Registry;
use Magento\Sales\Api\Data\OrderInterface;

class GuestOrderValidator implements ArgumentInterface
{
    /**
     * We use registry to get current order
     * @see \Magento\Sales\Helper\Guest::loadValidOrder
     * @var Registry
     */
    private Registry $registry;

    public function __construct(
        Registry $registry
    ) {
        $this->registry = $registry;
    }

    public function isGuestCustomer(): bool
    {
        /** @var OrderInterface|null $order */
        $order = $this->registry->registry('current_order');

        return (bool)($order && $order->getCustomerIsGuest());
    }
}
