<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Hyva Compatibility (System)
 */

namespace Amasty\GdprHyva\ViewModel;

use Amasty\Gdpr\Model\Config as GdprConfigProvider;
use Amasty\GdprHyva\Model\GdprCookieConfigProvider;
use Amasty\GdprHyva\Model\XssEscaper;
use Magento\Framework\Module\Manager;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class Config implements ArgumentInterface
{
    private const AMASTY_GDPRCOOKIE = 'Amasty_GdprCookie';
    private const AMASTY_GDPRCOOKIE_HYVA = 'Amasty_GdprCookieHyva';

    private GdprConfigProvider $gdprConfigProvider;
    private GdprCookieConfigProvider $gdprCookieConfigProvider;
    private XssEscaper $xssEscaper;
    private Manager $moduleManager;

    public function __construct(
        GdprConfigProvider       $configProvider,
        GdprCookieConfigProvider $gdprCookieConfigResolver,
        XssEscaper               $xssEscaper,
        Manager                  $moduleManager
    ) {
        $this->gdprConfigProvider = $configProvider;
        $this->gdprCookieConfigProvider = $gdprCookieConfigResolver;
        $this->xssEscaper = $xssEscaper;
        $this->moduleManager = $moduleManager;
    }

    public function isModuleEnabled(): bool
    {
        return $this->gdprConfigProvider->isModuleEnabled();
    }

    public function getDpoEmail(): string
    {
        return $this->gdprConfigProvider->getDpoEmail();
    }

    public function getDpoInfo(): string
    {
        return $this->xssEscaper->escapeTinyMceHtml($this->gdprConfigProvider->getDpoInfo());
    }

    public function isCookieEnabled(): bool
    {
        $isCookieModulesEnabled = $this->moduleManager->isEnabled(self::AMASTY_GDPRCOOKIE)
            && $this->moduleManager->isEnabled(self::AMASTY_GDPRCOOKIE_HYVA);

        $isCookieBarEnabled = $this->gdprCookieConfigProvider->isCookieBarEnabled();

        return $isCookieModulesEnabled && $isCookieBarEnabled;
    }
}
