<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Hyva Compatibility (System)
 */

namespace Amasty\GdprHyva\ViewModel;

use Amasty\Gdpr\Block\AccountCheckbox;
use Amasty\Gdpr\Model\ConsentLogger;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\View\LayoutInterface;
use Amasty\Gdpr\Model\Consent\DataProvider\PrivacySettingsDataProviderFactory;

class Checkbox implements ArgumentInterface
{
    private const CHECKBOX_TEMPLATE = 'Amasty_GdprHyva::checkbox.phtml';

    /**
     * @var LayoutInterface
     */
    private $layout;

    /**
     * @var PrivacySettingsDataProviderFactory
     */
    private $privacySettingsDataProviderFactory;

    public function __construct(
        LayoutInterface $layout,
        PrivacySettingsDataProviderFactory $privacySettingsDataProviderFactory
    ) {
        $this->layout = $layout;
        $this->privacySettingsDataProviderFactory = $privacySettingsDataProviderFactory;
    }

    public function getAccountPrivacyBlock(): AccountCheckbox
    {
        return $this->layout->createBlock(
            AccountCheckbox::class,
            'amasty.gdpr.account.settings.consents.checkbox',
            [
                'dataProvider' => $this->privacySettingsDataProviderFactory->create(),
                'scope' => ConsentLogger::FROM_PRIVACY_SETTINGS
            ]
        )->setTemplate(self::CHECKBOX_TEMPLATE);
    }
}
