<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Hyva Compatibility (System)
 */

namespace Amasty\GdprHyva\Plugin\Block;

use Amasty\Gdpr\Block\Checkbox;
use Amasty\Gdpr\Block\SubscribePlugin;
use Amasty\Gdpr\Model\ConsentLogger;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\Exception\LocalizedException;
use Magento\Newsletter\Block\Subscribe as SubscribeBlock;
use Psr\Log\LoggerInterface;

class SubscribeFormAddCheckbox extends SubscribePlugin
{
    private const CHECKBOX_BLOCK_PREFIX = 'amasty_gdpr_newsletter';
    private CurrentTheme $currentTheme;
    private LoggerInterface $logger;

    public function __construct(
        CurrentTheme    $currentTheme,
        LoggerInterface $logger
    ) {
        $this->currentTheme = $currentTheme;
        $this->logger = $logger;
    }

    /**
     * @param SubscribeBlock $subject
     * @param $result
     *
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(SubscribeBlock $subject, $result)
    {
        if ($this->currentTheme->isHyva()) {
            return $this->injectCheckbox($subject, $result);
        }

        return parent::afterToHtml($subject, $result);
    }

    public function injectCheckbox(SubscribeBlock $subject, string $result): string
    {
        try {
            $checkboxBlock = $subject->getLayout()->createBlock(
                Checkbox::class,
                self::CHECKBOX_BLOCK_PREFIX . '.' . $subject->getNameInLayout(),
                [
                    'scope' => ConsentLogger::FROM_SUBSCRIPTION
                ]
            )->setTemplate('Amasty_GdprHyva::checkbox.phtml')->toHtml();

            if ($checkboxBlock) {
                $pos = strripos($result, '<button ');

                if ($pos) {
                    $endOfHtml = substr($result, $pos);
                    $result = substr_replace($result, $checkboxBlock, $pos) . $endOfHtml;
                }
            }
        } catch (LocalizedException $e) {
            $this->logger->error('Cannot add checkbox to the subscribe form:' . $e->getMessage());
        }

        return $result;
    }
}
