<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Hyva Compatibility (System)
 */

namespace Amasty\GdprHyva\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class GdprCookieConfigProvider extends ConfigProviderAbstract
{
    public const COOKIE_POLICY_BAR = 'cookie_policy/bar';

    /**
     * @var string
     */
    protected $pathPrefix = 'amasty_gdprcookie/';

    public function isCookieBarEnabled(?string $scopeCode = null): bool
    {
        return (bool)$this->getValue(self::COOKIE_POLICY_BAR, $scopeCode);
    }
}
