<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Hyva Compatibility (System)
 */

namespace Amasty\GdprHyva\Block;

use Magento\Framework\View\Element\Template;
use Amasty\Gdpr\Model\Config as GdprConfig;

/**
 * @method self setTitle(string $title)
 */
class DpoInfo extends Template
{
    private GdprConfig $configProvider;

    public function __construct(
        GdprConfig $configProvider,
        Template\Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->configProvider = $configProvider;
    }

    protected function _toHtml(): string
    {
        $this->setTitle($this->configProvider->getDpoSectionName());

        return parent::_toHtml();
    }
}
