<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR Hyva Compatibility (System)
 */

namespace Amasty\GdprHyva\Block;

use Amasty\Gdpr\Model\Consent\DataProvider\PrivacySettingsDataProvider;
use Amasty\Gdpr\Model\Consent\DataProvider\PrivacySettingsDataProviderFactory;
use Amasty\Gdpr\Model\ConsentLogger;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\Template;
use Psr\Log\LoggerInterface;

class Checkbox extends Template
{
    private PrivacySettingsDataProvider $privacySettingsProvider;
    private LoggerInterface $logger;

    public function __construct(
        PrivacySettingsDataProviderFactory $privacySettingsDataProviderFactory,
        LoggerInterface $logger,
        Template\Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->privacySettingsProvider = $privacySettingsDataProviderFactory->create();
        $this->logger = $logger;
    }

    /**
     * @return string|void
     */
    protected function _toHtml()
    {
        try {
            $privacyItems = $this->privacySettingsProvider->getData(ConsentLogger::FROM_PRIVACY_SETTINGS);
        } catch (NoSuchEntityException|LocalizedException $e) {
            $this->logger->error('Cannot get privacy policies:' . $e->getMessage());
            $privacyItems = [];
        }

        if (!empty($privacyItems)) {
            return parent::_toHtml();
        }
    }
}
