<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

use Amasty\Gdpr\Api\PolicyRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Framework\Api\SearchCriteriaBuilder;

$objectManager = Bootstrap::getObjectManager();

/** @var PolicyRepositoryInterface $policyRepository */
$policyRepository = Bootstrap::getObjectManager()->create(PolicyRepositoryInterface::class);

/** @var SearchCriteriaBuilder $searchCriteriaBuilder */
$searchCriteriaBuilder = $objectManager->create(SearchCriteriaBuilder::class);
$searchCriteria = $searchCriteriaBuilder
    ->addFilter('status', '1')
    ->addFilter('comment', 'Specific Test GraphQl Comment')
    ->create();

$policies = $policyRepository->getList($searchCriteria)->getItems();

foreach ($policies as $policy) {
    $policyRepository->delete($policy);
}
