<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

use Amasty\Gdpr\Api\Data\PolicyInterface;
use Amasty\Gdpr\Api\PolicyRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var PolicyInterface $policy */
$policy = Bootstrap::getObjectManager()->create(PolicyInterface::class);

/** @var PolicyRepositoryInterface $policyRepository */
$policyRepository = Bootstrap::getObjectManager()->create(PolicyRepositoryInterface::class);

$policy->setPolicyVersion('v2.0');
$policy->setStatus(1);
$policy->setContent('Specific Test GraphQl Policy Content <h4><strong>Contacting Us</strong></h4>');
$policy->setComment('Specific Test GraphQl Comment');

$policyRepository->save($policy);
