<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

use Amasty\Gdpr\Api\ConsentRepositoryInterface;
use Amasty\Gdpr\Api\Data\ConsentInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var ConsentInterface $consent */
$consent = Bootstrap::getObjectManager()->create(ConsentInterface::class);

/** @var ConsentRepositoryInterface $consentRepository */
$consentRepository = Bootstrap::getObjectManager()->create(ConsentRepositoryInterface::class);

$consent->setConsentCode('privacy_test_graphql_checkbox');
$consent->setConsentLocation(['registration', 'checkout']);
$consent->setStoreId(0);
$consent->setConsentName('Privacy Test GraphQl Checkbox');
$consent->setIsEnabled(1);
$consent->setIsRequired(1);
$consent->setIsLogTheConsent(1);
$consent->setIsHideTheConsentAfterUserLeftTheConsent(0);
$consent->setPrivacyLinkType(0);
$consent->setConsentText('I have read and accept the graphQl <a href="{link}">privacy policy</a>');
$consent->setVisibility(0);
$consent->setSortOrder(0);

$consentRepository->save($consent);
