<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Test\GraphQl;

use Amasty\Gdpr\Api\ConsentRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmGetGdprConsentsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amGetGdprConsents';

    /**
     * @var ConsentRepositoryInterface
     */
    private $consentRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->consentRepository = $objectManager->get(ConsentRepositoryInterface::class);
    }

    /**
     * @group amasty_gdpr
     *
     * @magentoApiDataFixture Amasty_GdprGraphQl::Test/GraphQl/_files/create_consent.php
     */
    public function testAmGetGdprConsents(): void
    {
        $consentId = $this->consentRepository->getByConsentCode('privacy_test_graphql_checkbox')->getConsentId();

        $fields = [
            [
                'consent_id' => $consentId,
                'name' => 'Privacy Test GraphQl Checkbox',
                'consent_code' => 'privacy_test_graphql_checkbox',
                'is_required' => true,
                'hide_the_consent_after_user_left_the_consent' => false,
                'consent_location' => 'registration,checkout',
                'link_type' => 0,
                'cms_page_id' => null,
                'consent_text' => 'I have read and accept the graphQl <a href="{link}">privacy policy</a>',
                'visibility' => false,
                'has_agreement' => false,
                'sort_order' => 0
            ]
        ];

        $query = $this->getQuery('checkout');
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY], $fields);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(string $location): string
    {
        return <<<QUERY
query {
    amGetGdprConsents(location: "$location") {
        consent_id
        name
        consent_code
        is_required
        hide_the_consent_after_user_left_the_consent
        consent_location
        link_type
        cms_page_id
        consent_text
        visibility
        has_agreement
        sort_order
    }
}
QUERY;
    }
}
