<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Test\GraphQl;

use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmGetGdprAccountTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amGetGdprAccount';

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    protected function setUp(): void
    {
        parent::setUp();

        $this->storeManager = Bootstrap::getObjectManager()->get(StoreManagerInterface::class);
    }

    /**
     * @group amasty_gdpr
     *
     * @magentoConfigFixture base_website amasty_gdpr/customer_access_control/privacy_settings_tab_name GraphQl_Settings
     * @magentoConfigFixture base_website amasty_gdpr/customer_access_control/policies_text_section 1
     * @magentoConfigFixture base_website amasty_gdpr/customer_access_control/download 1
     * @magentoConfigFixture base_website amasty_gdpr/customer_access_control/anonymize 1
     * @magentoConfigFixture base_website amasty_gdpr/customer_access_control/delete 1
     */
    public function testAmGetGdprAccount(): void
    {
        $baseUrl = $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_WEB);

        $fields = [
            'title' => 'Download personal data',
            'content' =>
                "Here you can download a copy of your personal data which we store for your account in CSV format.",
            'hasCheckbox' => true,
            'checkboxText' => "Merge into one file",
            'hidePassword' => false,
            'needPassword' => false,
            'submitText' => "Download",
            'action' => $baseUrl . 'gdpr/customer/downloadCsv/',
            'actionCode' => "download"
        ];

        $query = $this->getQuery();
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals('GraphQl_Settings', $response[self::MAIN_QUERY_KEY]['title']);
        $this->assertCount(4, $response[self::MAIN_QUERY_KEY]['settings']);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['settings'][1], $fields);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(): string
    {
        return <<<QUERY
query {
    amGetGdprAccount {
        title
        settings {
            title
            content
            hasCheckbox
            checkboxText
            hidePassword
            needPassword
            submitText
            action
            actionCode
        }
    }
}
QUERY;
    }
}
