<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Model\Resolver\Validation;

use Amasty\Gdpr\Model\Config;
use Amasty\Gdpr\Model\GiftRegistryProvider;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\App\ProductMetadataInterface;

class CustomerHasActiveGiftRegistry
{
    /**
     * @var Config
     */
    private $configProvider;

    /**
     * @var ProductMetadataInterface
     */
    private $productMetadata;

    /**
     * @var GiftRegistryProvider
     */
    private $giftRegistryProvider;

    public function __construct(
        Config $configProvider,
        GiftRegistryProvider $giftRegistryProvider,
        ProductMetadataInterface $productMetadata
    ) {
        $this->configProvider = $configProvider;
        $this->productMetadata = $productMetadata;
        $this->giftRegistryProvider = $giftRegistryProvider;
    }

    public function execute(CustomerInterface $customer): bool
    {
        return $this->productMetadata->getEdition() === 'Enterprise'
            && $this->configProvider->isAvoidGiftRegistryAnonymization()
            && $this->giftRegistryProvider->checkGiftRegistries($customer->getId());
    }
}
