<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Model\Resolver\Validation;

use Amasty\Gdpr\Model\ResourceModel\DeleteRequest;
use Magento\Customer\Api\Data\CustomerInterface;

class CustomerHasActiveDeleteRequest
{
    /**
     * @var DeleteRequest\CollectionFactory
     */
    private $deleteRequestCollectionFactory;

    public function __construct(DeleteRequest\CollectionFactory $deleteRequestCollectionFactory)
    {
        $this->deleteRequestCollectionFactory = $deleteRequestCollectionFactory;
    }

    public function execute(CustomerInterface $customer): bool
    {
        $collection = $this->deleteRequestCollectionFactory->create();
        $collection->addFieldToFilter('customer_id', $customer->getId());

        return $collection->getSize() > 0;
    }
}
