<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Model\Resolver\Mutation;

use Amasty\Gdpr\Model\Config;
use Amasty\Gdpr\Model\CustomerData;
use Amasty\GdprGraphQl\Model\Resolver\CustomerProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlAuthenticationException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetPersonalData implements ResolverInterface
{
    /**
     * @var Config
     */
    private $configProvider;

    /**
     * @var CustomerData
     */
    private $customerData;

    /**
     * @var CustomerProvider
     */
    private $customerProvider;

    public function __construct(
        Config $configProvider,
        CustomerData $customerData,
        CustomerProvider $customerProvider
    ) {
        $this->configProvider = $configProvider;
        $this->customerData = $customerData;
        $this->customerProvider = $customerProvider;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        if (!$this->configProvider->isAllowed(Config::DOWNLOAD)) {
            throw new GraphQlAuthenticationException(__('Access denied.'));
        }

        $customer = $this->customerProvider->getCustomer($context, $args ?? []);
        $personalData = $this->customerData->getPersonalData((int)$customer->getId(), false);
        $result = [];

        foreach ($personalData as $name => $personalDataPart) {
            $personalDataPart = array_map(function ($dataPair) {
                return [
                    'label' => $dataPair[0] ?? '',
                    'value' => $dataPair[1] ?? '',
                ];
            }, $personalDataPart);

            $result[] = [
                'name' => $name,
                'personalDataPart' => $personalDataPart
            ];
        }

        return $result;
    }
}
