<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Model\Resolver;

use Amasty\Gdpr\Model\Consent\DataProvider\ConsentPolicyContentResolver;
use Amasty\Gdpr\Model\Policy\DataProvider\PolicyPopupDataProvider;
use Magento\Cms\Model\Template\FilterProvider;
use Magento\Customer\Model\Session;
use Magento\CustomerGraphQl\Model\Customer\GetCustomer;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetPolicyText implements ResolverInterface
{
    /**
     * @var FilterProvider
     */
    private $filterProvider;

    /**
     * @var PolicyPopupDataProvider
     */
    private $policyPopupDataProvider;

    /**
     * @var ConsentPolicyContentResolver
     */
    private $policyContentResolver;

    /**
     * @var Session
     */
    private $customerSession;

    /**
     * @var GetCustomer
     */
    private $getCustomer;

    public function __construct(
        FilterProvider $filterProvider,
        PolicyPopupDataProvider $policyPopupDataProvider,
        ConsentPolicyContentResolver $policyContentResolver,
        Session $customerSession,
        GetCustomer $getCustomer
    ) {
        $this->filterProvider = $filterProvider;
        $this->policyPopupDataProvider = $policyPopupDataProvider;
        $this->policyContentResolver = $policyContentResolver;
        $this->customerSession = $customerSession;
        $this->getCustomer = $getCustomer;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $consentId = (int)($args['id'] ?? 0);
        $policyData = $consentId
            ? $this->policyContentResolver->getConsentPolicyData($consentId)
            : $this->policyContentResolver->getGeneralPolicyData();

        if (isset($policyData[ConsentPolicyContentResolver::DATA_CONTENT])) {
            $policyData[ConsentPolicyContentResolver::DATA_CONTENT] = $this->filterProvider->getPageFilter()
                ->filter((string)$policyData[ConsentPolicyContentResolver::DATA_CONTENT]);
        }

        if (!$this->customerSession->getCustomerId()) {
            try {
                $customerId = $this->getCustomer->execute($context)->getId();
                $this->customerSession->setCustomerId($customerId);
            } catch (\Exception $e) {//phpcs:ignore Magento2.CodeAnalysis.EmptyBlock.DetectedCatch
                //do nothing
            }
        }

        $popupData = $this->policyPopupDataProvider->getData();
        $policyData['need_show'] = $popupData['show'] ?? false;
        $policyData['version'] = $popupData['policyVersion'] ?? '';
        $policyData['version_changed'] = $popupData['versionChanged'] ?? false;

        return $policyData;
    }
}
