<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Model\Resolver;

use Amasty\Gdpr\Block\Settings;
use Amasty\Gdpr\Model\Config;
use Magento\CustomerGraphQl\Model\Customer\GetCustomer;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetAccountSettings implements ResolverInterface
{
    /**
     * @var Settings
     */
    private $settings;

    /**
     * @var GetCustomer
     */
    private $getCustomer;

    /**
     * @var Config
     */
    private $configProvider;

    public function __construct(
        Settings $settings,
        GetCustomer $getCustomer,
        Config $configProvider
    ) {
        $this->settings = $settings;
        $this->getCustomer = $getCustomer;
        $this->configProvider = $configProvider;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        try {
            $this->getCustomer->execute($context);
            $this->settings->setData($this->settings::NEED_PASSWORD_LAYOUT_VARIABLE_NAME, true);
        } catch (\Exception $e) {
            $this->settings->setData($this->settings::NEED_PASSWORD_LAYOUT_VARIABLE_NAME, false);
        }

        return [
            'title' => $this->configProvider->getPrivacySettingsTabName(),
            'settings' => $this->settings->getPrivacySettings()
        ];
    }
}
