<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package GDPR GraphQl for Magento 2 (System)
 */

namespace Amasty\GdprGraphQl\Model\Resolver;

use Magento\CustomerGraphQl\Model\Customer\CheckCustomerPassword;
use Magento\CustomerGraphQl\Model\Customer\GetCustomer;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;

class CustomerProvider
{
    public const PASSWORD_KEY = 'password';

    /**
     * @var GetCustomer
     */
    private $getCustomer;

    /**
     * @var CheckCustomerPassword
     */
    private $checkCustomerPassword;

    public function __construct(
        GetCustomer $getCustomer,
        CheckCustomerPassword $checkCustomerPassword
    ) {
        $this->getCustomer = $getCustomer;
        $this->checkCustomerPassword = $checkCustomerPassword;
    }

    public function getCustomer(ContextInterface $context, array $args)
    {
        $input = $args['input'] ?? [];

        if (!isset($input[self::PASSWORD_KEY]) || empty($input[self::PASSWORD_KEY])) {
            throw new GraphQlInputException(__('Password required.'));
        }

        $customer = $this->getCustomer->execute($context);
        $this->checkCustomerPassword->execute($input[self::PASSWORD_KEY], (int)$customer->getId());

        return $customer;
    }
}
